﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;

namespace WindowsFormsApplication1
{
    partial class FormMain
    {
        // The list of controls to be enabled when the BLD04A is connected/disconnected.
        List<Control> controlList_ControlsToBeEnabledUponConnected = new List<Control>();
        List<Control> controlList_ControlsToBeEnabledUponDisconnected = new List<Control>();



        // Refresh the COM List combo box.
        private void refreshComList()
        {
            // Clear all the items in the combo box.
            this.comboBoxComList.Items.Clear();

            // Get the list of the available COM Ports and add them to the combo box.
            String[] stringArray_ComList = System.IO.Ports.SerialPort.GetPortNames();
            if (stringArray_ComList.Length > 0)
            {
                foreach (String string_Com in stringArray_ComList)
                {
                    this.comboBoxComList.Items.Add(string_Com);
                }

                if (stringArray_ComList.Length > 0)

                    // Select the first item.
                    this.comboBoxComList.SelectedIndex = 0;
            }

            else
            {
                MessageBox.Show("Warning: No valid COM Port found in your system!", "Warning");
            }
        }



        // Refresh the Baud Rate List combo box.
        private void refreshBaudRateList()
        {
            // Clear all the items in the combo box.
            this.comboBoxBaudRateList.Items.Clear();

            // Add the items to the combo box.
            this.comboBoxBaudRateList.Items.Add(4800);
            this.comboBoxBaudRateList.Items.Add(9600);
            this.comboBoxBaudRateList.Items.Add(19200);
            this.comboBoxBaudRateList.Items.Add(38400);
            this.comboBoxBaudRateList.Items.Add(57600);
            this.comboBoxBaudRateList.Items.Add(115200);

            // Select 9600 as default baud rate.
            this.comboBoxBaudRateList.SelectedIndex = this.comboBoxBaudRateList.Items.IndexOf(9600);
        }



        // User clicks the "Refresh" button.
        private void buttonRefreshComList_Click(object sender, EventArgs e)
        {
            // Refresh the COM List combo box.
            this.refreshComList();
        }



        // User clicks the "Connect / Disconnect" button.
        private void buttonConnectDisconnect_Click(object sender, EventArgs e)
        {
            // If current state is "Not Connected"...
            if (this.labelConnectedNotConnected.Text == "Not Connected")
            {
                // If the serial port is already opened, close it first.
                if (this.serialPort.IsOpen == true)
                {
                    // Flush the buffers and close the serial port.
                    this.serialPort.DiscardInBuffer();
                    this.serialPort.DiscardOutBuffer();
                    this.serialPort.Close();
                }

                // Assign the selected port name and baud rate.
                this.serialPort.PortName = this.comboBoxComList.SelectedItem.ToString();
                this.serialPort.BaudRate = Convert.ToInt32(this.comboBoxBaudRateList.SelectedItem);

                try
                {
                    // Open the serial port.
                    this.serialPort.Open();
                }
                catch (System.Exception)
                {
                    // Show error if unable to open the serial port.
                    MessageBox.Show("Error: Unable to open " + this.serialPort.PortName, "Error");
                }

                // If the COM Port is opened successfully...
                if (this.serialPort.IsOpen == true)
                {
                    // If the BLD04A is connected...
                    if (this.bld04aCommand.isBld04aConnected() == true)
                    {
                        // Change the connect button to disconnect.
                        this.buttonConnectDisconnect.Text = "Disconnect";

                        // Change the status text to connected, and change the color to green.
                        this.labelConnectedNotConnected.Text = "Connected";
                        this.labelConnectedNotConnected.ForeColor = System.Drawing.Color.LightGreen;

                        // Enable the related controls.
                        foreach (Control controlToBeEnabled in this.controlList_ControlsToBeEnabledUponConnected)
                        {
                            controlToBeEnabled.Enabled = true;
                        }

                        // Disable the unrelated controls.
                        foreach (Control controlToBeDisabled in this.controlList_ControlsToBeEnabledUponDisconnected)
                        {
                            controlToBeDisabled.Enabled = false;
                        }

                        // Clear the picture box.
                        this.graphicsReadSpeed.Clear(this.pictureBoxReadSpeed.BackColor);
                    }
                    // If the BLD04A is not connected...
                    else
                    {
                        // Show error if unable to connect to the BLD04A.
                        MessageBox.Show("Error: Unable to communicate with the BLD04A", "Error");

                        // Flush the buffers and close the serial port.
                        this.serialPort.DiscardInBuffer();
                        this.serialPort.DiscardOutBuffer();
                        this.serialPort.Close();
                    }
                }
            }

            // If current state is "Connected"...
            else if (this.labelConnectedNotConnected.Text == "Connected")
            {
                // Stop the read speed if current state is "Start"...
                if (this.buttonReadSpeedStartStop.Text == "Stop")
                {
                    // Disable the Timer.
                    this.timerReadSpeed.Enabled = false;

                    // Change the text to "Stop"
                    this.buttonReadSpeedStartStop.Text = "Start";

                    // Change the current speed label to "Current Speed (rpm): N/A".
                    this.labelCurrentSpeed.Text = "Current Speed (rpm): N/A";

                    // Reset the speed list.
                    this.speedList.Clear();
                }

                // If the serial port is already opened, close it.
                if (this.serialPort.IsOpen == true)
                {
                    // Flush the buffers and close the serial port.
                    this.serialPort.DiscardInBuffer();
                    this.serialPort.DiscardOutBuffer();
                    this.serialPort.Close();
                }

                // If the COM Port is closed successfully...
                if (this.serialPort.IsOpen == false)
                {
                    // Change the disconnect button to connect.
                    this.buttonConnectDisconnect.Text = "Connect";

                    // Change the status text to "Not Connected", and change the color to red.
                    this.labelConnectedNotConnected.Text = "Not Connected";
                    this.labelConnectedNotConnected.ForeColor = System.Drawing.Color.Red;

                    // Enable the related controls.
                    foreach (Control controlToBeEnabled in this.controlList_ControlsToBeEnabledUponDisconnected)
                    {
                        controlToBeEnabled.Enabled = true;
                    }

                    // Disable the related controls.
                    foreach (Control controlToBeDisabled in this.controlList_ControlsToBeEnabledUponConnected)
                    {
                        controlToBeDisabled.Enabled = false;
                    }
                }
            }

        }


        // User clicks the "Set New Baud Rate" button.
        private void buttonNewBaud_Click(object sender, EventArgs e)
        {
            new Form2(this).Show();
        }



    }
}
